from numpy.random import poisson, randint

class Match:
    def __init__(self, position1, position2, date):
        self._date = date
        self._position1 = position1
        self._position2 = position2
        self._data = None
    @property
    def date(self):
        return self._date
    @property
    def position1(self):
        return self._position1
    @property
    def position2(self):
        return self._position2
    @property
    def data(self):
        return self._data


    def play(self):
        def get_score(attack, defense):
            return poisson(3*attack/defense)        
        goals1 = get_score(self._position1.team.attack, self._position2.team.defense)
        goals2 = get_score(self._position2.team.attack, self._position1.team.defense)
        self._data = {"teams": (self._position1.team.name, self._position2.team.name),
                      "goals": (goals1, goals2)}
        if goals1 == goals2:
            overtime_winner = randint(0,1)
            self._data["overtime_winner"] = overtime_winner

        #printing here is prety bad, but it is 1AM
        pgoals1 = goals1
        pgoals2 = goals2
        pot=""
        if goals1 == goals2:
            pot="(ot)"
            if self._data["overtime_winner"] == 0:
                pgoals1 += 1
            else:
                pgoals2 += 1
        print("%s - %s    %d:%d %s\n" % (self._position1.team.name, self._position2.team.name, pgoals1, pgoals2, pot))


